import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../../util/processResponse.js";

const initialState = {
    newReview: {},
    loading: false,
};

export const postNewReview = createAsyncThunk(
    "user/postNewReview",
    async (obj) => {
        try {
            const { access_token, updateRevUrl, method, formData } = obj;
            const response = await mutationResponse(
                updateRevUrl,
                method,
                formData,
                access_token
            );
            return response;
        } catch (err) {
            return;
        }
    }
);

const postNewReviewSlice = createSlice({
    name: "user",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(postNewReview.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(postNewReview.fulfilled, (state, { payload }) => {
            state.newReview = payload;
            state.loading = false;
        });
        builder.addCase(postNewReview.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default postNewReviewSlice.reducer;
